"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var DefaultShapeIndicators_exports = {};
__export(DefaultShapeIndicators_exports, {
  DefaultShapeIndicators: () => DefaultShapeIndicators
});
module.exports = __toCommonJS(DefaultShapeIndicators_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var import_state_react = require("@tldraw/state-react");
var import_react = require("react");
var import_useEditor = require("../../hooks/useEditor");
var import_useEditorComponents = require("../../hooks/useEditorComponents");
const DefaultShapeIndicators = (0, import_react.memo)(function DefaultShapeIndicators2() {
  const editor = (0, import_useEditor.useEditor)();
  const rPreviousSelectedShapeIds = (0, import_react.useRef)(/* @__PURE__ */ new Set());
  const idsToDisplay = (0, import_state_react.useValue)(
    "should display selected ids",
    () => {
      const prev = rPreviousSelectedShapeIds.current;
      const next = /* @__PURE__ */ new Set();
      if (
        // We only show indicators when in the following states...
        editor.isInAny(
          "select.idle",
          "select.brushing",
          "select.scribble_brushing",
          "select.editing_shape",
          "select.pointing_shape",
          "select.pointing_selection",
          "select.pointing_handle"
        ) && // ...but we hide indicators when we've just changed a style (so that the user can see the change)
        !editor.getInstanceState().isChangingStyle
      ) {
        const selected = editor.getSelectedShapeIds();
        for (const id of selected) {
          next.add(id);
        }
        if (editor.isInAny("select.idle", "select.editing_shape")) {
          const instanceState = editor.getInstanceState();
          if (instanceState.isHoveringCanvas && !instanceState.isCoarsePointer) {
            const hovered = editor.getHoveredShapeId();
            if (hovered) next.add(hovered);
          }
        }
      }
      if (prev.size !== next.size) {
        rPreviousSelectedShapeIds.current = next;
        return next;
      }
      for (const id of next) {
        if (!prev.has(id)) {
          rPreviousSelectedShapeIds.current = next;
          return next;
        }
      }
      return prev;
    },
    [editor]
  );
  const renderingShapes = (0, import_state_react.useValue)("rendering shapes", () => editor.getRenderingShapes(), [editor]);
  const { ShapeIndicator } = (0, import_useEditorComponents.useEditorComponents)();
  if (!ShapeIndicator) return null;
  return renderingShapes.map(({ id }) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(ShapeIndicator, { shapeId: id, hidden: !idsToDisplay.has(id) }, id + "_indicator"));
});
//# sourceMappingURL=DefaultShapeIndicators.js.map
